﻿<%@ Page Title="Referral Follow Ups" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="BioContactFollowups.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.BioContactFollowups" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">
    
    <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();

        });
    </script>
    <br />
    <div class = "excludeSaveWarnings">
    <asp:Label ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Filter by Last Name:</asp:Label>
                            
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Clear"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" 
            />
        
     </div>
     <br />
     <asp:GridView ID = "GridViewReferralFollowUps" runat = "server" DataSourceID = "ObjectDataSourceFollowUps" AutoGenerateColumns = "false"
        AllowPaging="True" PageSize="20" DataKeyNames = "ReferralId, ContactId" OnRowCommand = "FollowUps_RowCommand" 
         AllowSorting = "true" CssClass="gridRegistry" PagerStyle-CssClass="pager">
       <EmptyDataTemplate>
            No followups exist for any referrals
       </EmptyDataTemplate> 
        
        <Columns>
        
            <asp:TemplateField HeaderText = "Referral Number" SortExpression = "ReferralId" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelRefID" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReferralId"))) %>' ></asp:Label> 
                
                </ItemTemplate> 
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Patient Name" SortExpression = "PatientLastName">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientFullName"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Site Number" SortExpression="StationNumber">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelStationNumber" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("StationNumber"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
           
            <asp:TemplateField HeaderText="Facility" SortExpression="InstitutionName">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelInstitution" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("InstitutionName"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Reason" SortExpression = "Reason">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelReason" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("Reason"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Due Date" SortExpression = "DueDate">
                    
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelDueDate" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("NormalizedDueDate"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
                                             
            <asp:TemplateField HeaderText="Remind Me On" SortExpression = "ReminderDate">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelReminderDate" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("NormalizedReminderDate"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="" SortExpression = "FollowUpType" Visible = "false">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelFollowupType" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("FollowUpType"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" AccessibleHeaderText = "Select"  />
            
        </Columns>
    </asp:GridView>    
     
    <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />    
    <asp:ObjectDataSource ID="ObjectDataSourceFollowUps" runat="server" 
            SelectMethod="GetReferralFollowups" 
            SelectCountMethod="GetReferralFollowupsCount" 
            StartRowIndexParameterName="START_ROW" 
            MaximumRowsParameterName="MAX_ROWS" 
            SortParameterName="SORT_COLUMN"
            EnablePaging="True" 
            TypeName="VIRP.EFR.BLL.REFERRALManager">
            <SelectParameters>
                <asp:Parameter Name="CURRENT_USER" Type="String" />
                <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="Int32" />
                <asp:Parameter Name="PATIENT_LAST_NAME" Type="String" />
                <asp:Parameter Name="SORT_COLUMN" Type="String" />
                <asp:Parameter Name="START_ROW" Type="Int32" />
                <asp:Parameter Name="MAX_ROWS" Type="Int32" />           
            </SelectParameters>        
   </asp:ObjectDataSource>
</asp:Content>
